<?php
$page = "Marketplace Vendor Dashboard";
$page_url = "vendor_dashboard";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'marketdash';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$vendor_check = $dashboard->getDashboardByGlobalId($_SESSION[$sid . 'userid']);
if ($vendor_check !== null) {
    $lastSales = $dashboard->getsalesByGlobalId($_SESSION[$sid . 'userid']);
}
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
?>

<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .sales-section {
        border-radius: 8px;
        border: 1px solid #e9ecef;
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #0f172a;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .view-all-btn {
        background: #0d3e9b;
        color: white;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
        font-size: 14px;
        cursor: pointer;
        transition: background 0.3s ease;
    }

    .view-all-btn:hover {
        background: #3367d6;
    }

    .sales-list {
        padding: 0;
    }

    .sale-item {
        padding: 15px 25px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        align-items: center;
        justify-content: space-between;
        transition: background 0.3s ease;
    }

    .sale-item:hover {
        background: #f8f9fa;
    }

    .sale-item:last-child {
        border-bottom: none;
    }

    .customer-info {
        display: flex;
        align-items: center;
        flex: 1;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
    }

    .customer-details h6 {
        margin: 0;
        color: #0f172a;
        font-size: 14px;
        font-weight: 500;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .product-name {
        flex: 1;
        color: #6c757d;
        font-size: 14px;
        text-align: center;
    }

    .sale-amount {
        color: #0f172a;
        font-weight: 500;
        font-size: 14px;
    }

    .avatar-pink {
        background: #e91e63;
    }

    .avatar-blue {
        background: #2196f3;
    }

    .avatar-orange {
        background: #ff9800;
    }

    .avatar-green {
        background: #4caf50;
    }

    .avatar-purple {
        background: #9c27b0;
    }

    .avatar-teal {
        background: #009688;
    }

    .avatar-red {
        background: #f44336;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .stat-card {
            margin-bottom: 15px;
        }
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Dashboard</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <?php if ($vendor_check === null): ?>
            <div
                style="padding: 20px; border: 1px solid #f44336; background-color: #ffebee; color: #b71c1c; border-radius: 8px; text-align: center;">
                <h2>Vendor Account Not Available</h2>
                <p>You need to create a vendor account to access this dashboard.</p>
                <a href="/eservice/add_vendor"
                    style="display: inline-block; padding: 10px 20px; background-color: #1976d2; color: white; text-decoration: none; border-radius: 4px; font-weight: bold;">Create
                    Vendor Account</a>
            </div>
        <?php else: ?>
            <!-- Stats Row -->
            <div class="row stats-row">
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Revenue</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">N<?= number_format($vendor_check['total_revenue'], 2) ?></div>
                        <div class="stat-label">Sum of all sales transactions</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Sales</div>
                            <div class="stat-icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= $vendor_check['total_orders'] ?></div>
                        <div class="stat-label">Orders made in the last 30 days</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Best Selling Product</div>
                            <div class="stat-icon">
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= htmlspecialchars($vendor_check['top_selling_product'] ?? 'N/A') ?></div>
                        <div class="stat-label">Product driving the most sales</div>
                    </div>
                </div>
            </div>

            <!-- Recent Sales Section -->
            <?php if (!empty($lastSales)): ?>
                <div class="sales-section">
                    <div class="sales-header">
                        <div>
                            <h3 class="sales-title">Recent Sales</h3>
                            <p class="sales-subtitle">Recent sales from your store</p>
                        </div>
                        <button class="view-all-btn">View All</button>
                    </div>
                    <div class="sales-list">
                        <?php
                        $avatar_colors = ['avatar-pink', 'avatar-blue', 'avatar-orange', 'avatar-green', 'avatar-purple', 'avatar-teal', 'avatar-red'];
                        $color_index = 0;
                        foreach ($lastSales as $sale):
                            $initials = strtoupper(substr($sale['customer_name'], 0, 1) . (strpos($sale['customer_name'], ' ') !== false ? substr($sale['customer_name'], strpos($sale['customer_name'], ' ') + 1, 1) : ''));
                            ?>
                            <div class="sale-item">
                                <div class="customer-info">
                                    <div class="customer-avatar <?= $avatar_colors[$color_index] ?>"><?= $initials ?></div>
                                    <div class="customer-details">
                                        <h6><?= htmlspecialchars($sale['customer_name']) ?></h6>
                                        <p><?= htmlspecialchars($sale['customer_email']) ?></p>
                                    </div>
                                </div>
                                <div class="product-name"><?= htmlspecialchars($sale['product_names']) ?></div>
                                <div class="sale-amount">N<?= number_format($sale['total_amount'], 2) ?></div>
                            </div>
                            <?php
                            $color_index = ($color_index + 1) % count($avatar_colors);
                        endforeach;
                        ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="sales-section">
                    <div class="sales-header">
                        <div>
                            <h3 class="sales-title">Recent Sales</h3>
                            <p class="sales-subtitle">Recent sales from your store</p>
                        </div>

                    </div>
                    <div class="sales-list">
                        <div style="padding: 40px 0; text-align: center; color: #6c757d;">
                            <i class="fa fa-info-circle" style="font-size: 40px; color: #bdbdbd; margin-bottom: 15px;"></i>
                            <h4 style="margin: 10px 0 5px; color: #0f172a;">No Sales Yet</h4>
                            <p style="font-size: 15px;">You haven't made any sales yet.<br>Once you start selling, your recent
                                sales will appear here.</p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<script>
    // View All button functionality
    document.querySelector('.view-all-btn').addEventListener('click', function () {
        window.location.href = "vendor_sales.php";
    });

    // Sale item click functionality
    $(".sale-item").click(function () {
        $(this).css("background-color", "#e3f2fd").animate({
            backgroundColor: "#f8f9fa"
        }, 300);
    });

    // Initialize tooltips if needed
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>