<?PHP
$page = "Vendor Detail Dashboard";
$page_url = "vendor_detail";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'dasha';
    </script>
    <?PHP
    exit();
endif;
if (!isset($_GET['id'])):
    ?>
    <script>
        window.location.href = 'vendors';
    </script>
    <?php
    exit();
endif;
$vendorId = base64_decode(urldecode($_GET['id']));
if (!is_numeric($vendorId)):
    ?>
    <script>
        window.location.href = 'vendors';
    </script>
    <?php
    exit();
endif;
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 
//print_r($vendorId);

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);

$vendor = $dashboard->getVendorDetails($vendorId);
$admin_id = $_SESSION[$sid . 'userid'];
$updated = $dashboard->updateVendorStatus($vendorId, $newStatus, $admin_id);

//$mmdat = $ad->getTransactions("", 0, 20);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_status'])) {
    $newStatus = $_POST['new_status'];
    $updated = $dashboard->updateVendorStatus($vendorId, $newStatus, $admin_id);
    if ($updated) {
        echo "<p style='color:green;'>Status updated to " . htmlspecialchars($newStatus) . ".</p>";
        // Refresh vendor info after update
        $vendor = $dashboard->getVendorDetails($vendorId);
    } else {
        echo "<p style='color:red;'>Failed to update status.</p>";
    }
}
?>
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f7f9fc;
        margin: 0;
        padding: 20px;
    }

    .container {
        max-width: 700px;
        background: #fff;
        margin: 40px auto;
        padding: 30px 40px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        border-radius: 8px;
    }

    h1 {
        margin-bottom: 30px;
        color: #333;
        border-bottom: 2px solid #007bff;
        padding-bottom: 10px;
    }

    .field-label {
        font-weight: bold;
        color: #555;
        width: 160px;
        display: inline-block;
        vertical-align: top;
    }

    .field-value {
        color: #222;
        display: inline-block;
        max-width: 480px;
        word-wrap: break-word;
    }

    .row {
        margin-bottom: 15px;
    }

    .status {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 0.9em;
        font-weight: bold;
        color: white;
    }

    .status.active {
        background-color: #28a745;
    }

    .status.inactive {
        background-color: #dc3545;
    }

    .back-link {
        margin-top: 30px;
        display: inline-block;
        text-decoration: none;
        color: #007bff;
        font-weight: bold;
    }

    .back-link:hover {
        text-decoration: underline;
    }

    .btn {
        padding: 8px 16px;
        margin-right: 10px;
        font-size: 14px;
        cursor: pointer;
        border: none;
        border-radius: 4px;
        color: #fff;
    }

    .btn-approve {
        background-color: #28a745;
    }

    .btn-decline {
        background-color: #dc3545;
    }

    .btn-disabled {
        background-color: #6c757d;
        cursor: not-allowed;
    }
</style>

<div class="container">
    <h1>Vendor Details</h1>
    <div>
        <?php
        $status = strtolower($vendor->status);
        if ($status === 'active'):
            ?>
            <form method="post" style="display:inline;">
                <button type="submit" name="new_status" value="restricted" class="btn btn-decline">Restrict</button>
            </form>

            <button>
                <a href="admin_vendor_product.php?id=<?= urlencode(base64_encode($vendor->id)) ?>">View Vendor Products</a>
            </button>

            <button>
                <a href="admin_vendor_orders.php?id=<?= urlencode(base64_encode($vendor->id)) ?>">View Vendor Orders</a>
            </button>

        <?php elseif ($status === 'pending'): ?>
            <form method="post" style="display:inline;">
                <button type="submit" name="new_status" value="active" class="btn btn-approve">Approve</button>
            </form>
            <form method="post" style="display:inline;">
                <button type="submit" name="new_status" value="declined" class="btn btn-decline">Decline</button>
            </form>
        <?php elseif ($status === 'declined'): ?>
            <form method="post" style="display:inline;">
                <button type="submit" name="new_status" value="active" class="btn btn-approve">Approve</button>
            </form>
        <?php elseif ($status === 'restricted'): ?>
            <form method="post" style="display:inline;">
                <button type="submit" name="new_status" value="active" class="btn btn-approve">unrestrict</button>
            </form>
        <?php else: ?>
            <?= $status ?>
            <p>Status change options not available.</p>
        <?php endif; ?>
    </div>
    <div class="row">
        <span class="field-label">Business Name:</span>
        <span class="field-value"><?= htmlspecialchars($vendor->business_name) ?></span>
    </div>

    <div class="row">
        <span class="field-label">Name:</span>
        <span class="field-value"><?= htmlspecialchars($vendor->name) ?></span>
    </div>

    <div class="row">
        <span class="field-label">Email:</span>
        <span class="field-value"><?= htmlspecialchars($vendor->email) ?></span>
    </div>

    <div class="row">
        <span class="field-label">Address:</span>
        <span class="field-value"><?= htmlspecialchars($vendor->address ?: 'N/A') ?></span>
    </div>

    <div class="row">
        <span class="field-label">Location:</span>
        <span class="field-value"><?= htmlspecialchars($vendor->location ?: 'N/A') ?></span>
    </div>

    <div class="row">
        <span class="field-label">Type:</span>
        <span class="field-value"><?= htmlspecialchars($vendor->type ?: 'N/A') ?></span>
    </div>

    <div class="row">
        <span class="field-label">Bank Account:</span>
        <span class="field-value"><?= htmlspecialchars($vendor->bank_account ?: 'N/A') ?></span>
    </div>

    <div class="row">
        <span class="field-label">Business Info:</span>
        <span class="field-value"><?= nl2br(htmlspecialchars($vendor->business_info ?: 'N/A')) ?></span>
    </div>

    <div class="row">
        <span class="field-label">Status:</span>
        <span class="field-value">
            <?php if (strtolower($vendor->status) === 'active'): ?>
                <span class="status active">Active</span>
            <?php else: ?>
                <span class="status inactive"><?= htmlspecialchars($vendor->status) ?></span>
            <?php endif; ?>
        </span>
    </div>

    <div class="row">
        <span class="field-label">Created At:</span>
        <span class="field-value"><?= htmlspecialchars(date('F j, Y, g:i a', strtotime($vendor->created_at))) ?></span>
    </div>

    <div class="row">
        <span class="field-label">Last Updated:</span>
        <span class="field-value"><?= htmlspecialchars(date('F j, Y, g:i a', strtotime($vendor->updated_at))) ?></span>
    </div>

    <a class="back-link" href="vendors">&larr; Back to Vendors List</a>
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>

<?PHP
include_once 'includes/footer_end.php';
