<?php
$page = "Vendor Edit Product Dashboard";
$page_url = "vendor_product_detail";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'all_products';
    </script>
    <?php
    exit();
endif;

if (!isset($_GET['id'])):
    ?>
    <script>
        window.location.href = 'vendor_products';
    </script>
    <?php
    exit();
endif;

$productId = base64_decode(urldecode($_GET['id']));

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$categories = $dashboard->getAllCategories();
$product = $dashboard->getvendorproductDetails($productId, $vendor_id);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
$baseUrl = '/eservice';
if (!$product):
    ?>
    <script>
        window.location.href = 'vendor_products';
    </script>
    <?php
    exit();
endif;
?>

<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<style>
    /* Same CSS as vendor_add_product.php */
    .main-content {
        margin-left: 230px;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 20px 30px;
        border-bottom: 1px solid #e4e4e7;
        position: sticky;
        top: 0;
        z-index: 50;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        margin: 0;
    }

    .content-area {
        padding: 20px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb-separator {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb-current {
        color: #333;
        font-size: 14px;
    }

    .form-section {
        background: white;
        border-radius: 12px;
        border: 1px solid #e4e4e7;
        margin-bottom: 24px;
        overflow: hidden;
    }

    .section-header {
        padding: 24px 24px 16px;
        border-bottom: none;
    }

    .section-title {
        font-size: 18px;
        font-weight: 600;
        color: #1a1a1a;
        margin: 0 0 8px;
    }

    .section-subtitle {
        color: #6b7280;
        font-size: 14px;
        margin: 0;
        font-weight: 400;
    }

    .section-content {
        padding: 0 24px 24px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-label {
        font-weight: 500;
        color: #374151;
        margin-bottom: 8px;
        display: block;
        font-size: 14px;
    }

    .form-control {
        width: 100%;

        border: 1px solid #d1d5db;
        border-radius: 8px;
        font-size: 14px;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
        background: white;
    }

    .form-control:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .form-control::placeholder {
        color: #9ca3af;
    }

    .form-control-sm {
        padding: 8px 12px;
        font-size: 13px;
    }

    .categories-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 8px;
    }

    .manage-categories {
        color: #3b82f6;
        font-size: 14px;
        font-weight: 500;
        text-decoration: none;
        cursor: pointer;
    }

    .manage-categories:hover {
        color: #2563eb;
    }

    .ql-toolbar.ql-snow {
        border: 1px solid #d1d5db;
        border-bottom: none;
        border-radius: 8px 8px 0 0;
    }

    .ql-container.ql-snow {
        border: 1px solid #d1d5db;
        border-radius: 0 0 8px 8px;
        font-size: 14px;
    }

    .ql-editor {
        min-height: 120px;
    }

    .ql-editor.ql-blank::before {
        color: #9ca3af;
        font-style: normal;
    }

    .price-input-group {
        position: relative;
    }

    .price-input-group .currency-symbol {
        position: absolute;
        left: 16px;
        top: 50%;
        transform: translateY(-50%);
        color: #6b7280;
        font-weight: 500;
        z-index: 10;
    }

    .price-input-group .form-control {
        padding-left: 36px;
    }

    .price-helper-text {
        font-size: 12px;
        color: #6b7280;
        margin-top: 4px;
    }

    .image-upload-container {
        position: relative;
    }

    .image-upload {
        border: 2px dashed #d1d5db;
        border-radius: 12px;
        padding: 32px;
        text-align: center;
        background: #f9fafb;
        transition: border-color 0.3s ease;
        cursor: pointer;
        min-height: 160px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    .image-upload:hover {
        border-color: #3b82f6;
    }

    .image-preview-container {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-top: 15px;
    }

    .image-preview-item {
        position: relative;
        width: 100px;
        height: 100px;
        border-radius: 8px;
        overflow: hidden;
        border: 1px solid #e4e4e7;
    }

    .image-preview-item img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .image-remove-btn {
        position: absolute;
        top: 4px;
        right: 4px;
        background: rgba(220, 38, 38, 0.9);
        color: white;
        border: none;
        border-radius: 50%;
        width: 24px;
        height: 24px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        font-size: 12px;
        transition: background 0.3s ease;
        z-index: 10;
    }

    .image-remove-btn:hover {
        background: rgba(185, 28, 28, 1);
    }

    .image-upload .upload-icon {
        font-size: 32px;
        color: #9ca3af;
        margin-bottom: 12px;
    }

    .upload-text {
        color: #374151;
        font-weight: 500;
        margin-bottom: 4px;
    }

    .upload-subtext {
        color: #6b7280;
        font-size: 12px;
        margin-top: 8px;
    }

    .file-input {
        display: none;
    }

    .spec-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 16px;
        background: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        margin-bottom: 12px;
    }

    .spec-item input {
        flex: 1;
        border: none;
        background: none;
        padding: 4px;
        font-size: 14px;
    }

    .spec-item input:focus {
        outline: 1px solid #3b82f6;
        background: white;
        border-radius: 4px;
        padding: 8px;
    }

    .add-spec-btn,
    .add-destination-btn,
    .add-attribute-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        background: none;
        border: 1px solid #d1d5db;
        color: #374151;
        padding: 12px 20px;
        border-radius: 8px;
        cursor: pointer;
        font-size: 14px;
        font-weight: 500;
        width: 100%;
        transition: all 0.3s ease;
    }

    .add-spec-btn:hover,
    .add-destination-btn:hover,
    .add-attribute-btn:hover {
        background: #f9fafb;
        border-color: #3b82f6;
        color: #3b82f6;
    }

    .variants-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 16px;
    }

    .load-variant-btn {
        background: #f3f4f6;
        border: 1px solid #d1d5db;
        color: #374151;
        padding: 8px 16px;
        border-radius: 6px;
        font-size: 14px;
        cursor: pointer;
    }

    .create-new-btn {
        background: none;
        border: none;
        color: #3b82f6;
        font-size: 14px;
        font-weight: 500;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .variant-form {
        border: 1px solid #e5e7eb;
        border-radius: 12px;
        padding: 20px;
        margin-bottom: 16px;
    }

    .variant-name-input {
        margin-bottom: 16px;
    }

    .variant-row {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 16px;
    }

    .variant-row input {
        flex: 1;
    }


    .admin-reason {
        background: #fee2e2;
        padding: 10px;
        margin-top: 10px;
        border-left: 4px solid #dc2626;
        color: #a62c2c;
        border-radius: 4px;
    }

    .delete-btn {
        background: #fee2e2;
        border: 1px solid #fecaca;
        color: #dc2626;
        padding: 8px;
        border-radius: 6px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .settings-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 16px 0;
        border-bottom: 1px solid #f3f4f6;
    }

    .settings-item:last-child {
        border-bottom: none;
    }

    .settings-label {
        font-weight: 500;
        color: #374151;
        font-size: 14px;
    }

    .limit-input {
        margin-top: 12px;
        display: none;
    }

    .limit-input.show {
        display: block;
    }

    .toggle-switch {
        position: relative;
        width: 44px;
        height: 24px;
        background: #d1d5db;
        border-radius: 12px;
        cursor: pointer;
        transition: background 0.3s ease;
    }

    .toggle-switch.active {
        background: #3b82f6;
    }

    .toggle-switch::after {
        content: "";
        position: absolute;
        top: 2px;
        left: 2px;
        width: 20px;
        height: 20px;
        background: white;
        border-radius: 50%;
        transition: transform 0.3s ease;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }

    .toggle-switch.active::after {
        transform: translateX(20px);
    }

    .btn-primary {
        background: #3b82f6;
        border-color: #3b82f6;
        color: white;
        padding: 12px 24px;
        font-weight: 600;
        border-radius: 8px;
        font-size: 14px;
        width: 100%;
        margin-bottom: 12px;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        background: #2563eb;
        border-color: #2563eb;
    }

    .btn-outline {
        background: white;
        border: 1px solid #d1d5db;
        color: #374151;
        padding: 12px 24px;
        font-weight: 500;
        border-radius: 8px;
        font-size: 14px;
        width: 100%;
        margin-bottom: 12px;
        transition: all 0.3s ease;
    }

    .btn-outline:hover {
        background: #f9fafb;
        border-color: #9ca3af;
    }

    .btn-text {
        background: none;
        border: none;
        color: #3b82f6;
        padding: 12px 24px;
        font-weight: 500;
        font-size: 14px;
        width: 100%;
        cursor: pointer;
        transition: color 0.3s ease;
    }

    .btn-text:hover {
        color: #2563eb;
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
    }

    .alert-danger {
        background: #fee2e2;
        border: 1px solid #fecaca;
        color: #dc2626;
    }

    .alert-success {
        background: #d1fae5;
        border: 1px solid #6ee7b7;
        color: #065f46;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 15px;
        }

        .top-bar {
            padding: 15px;
        }

        .section-content {
            padding: 0 16px 16px;
        }

        .section-header {
            padding: 16px;
        }

        .variant-row {
            flex-direction: column;
        }

        .form-control {
            padding: 8px;
        }

        .image-upload {
            padding: 20px;
            min-height: 120px;
        }

        .btn-primary,
        .btn-outline,
        .btn-text {
            font-size: 13px;
            padding: 10px 16px;
        }
    }

    @media (max-width: 576px) {

        .variant-row input,
        .spec-item input {
            width: 100%;
        }

        .delete-btn {
            width: 100%;
            text-align: center;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Edit Product</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span class="breadcrumb-separator">></span>
            <span class="breadcrumb-current">Edit Product</span>
        </nav>

        <div class="alert alert-danger" id="errPan" style="display: none"></div>
        <div class="alert alert-success" id="succPan" style="display: none"></div>

        <form id="product_edit_form" role="form" method="post" data-toggle="validator" action="">
            <input type="hidden" name="product_id" value="<?= htmlspecialchars($productId) ?>">
            <div class="row">
                <!-- Left Column -->
                <div class="col-md-8">
                    <!-- Product Details -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Product Details</h3>
                            <p class="section-subtitle">Conciseness is highly recommended</p>
                        </div>
                        <div class="section-content">
                            <div class="form-group">
                                <label class="form-label">Name</label>
                                <input type="text" class="form-control" id="product_name" name="product_name"
                                    placeholder="Enter product name"
                                    value="<?= htmlspecialchars($product->name ?? '') ?>" required />
                            </div>

                            <div class="form-group">
                                <div class="categories-header">
                                    <label class="form-label">Categories</label>
                                    <!-- <a href="#" class="manage-categories">Manage categories</a> -->
                                </div>
                                <select class="form-control" id="category" name="category_id" required>
                                    <option value="">Select category</option>
                                    <?php foreach ($categories as $cat): ?>
                                        <option value="<?= $cat->id ?>" <?= $cat->id == ($product->category_id ?? '') ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($cat->name) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Description</label>
                                <div id="editor"><?= $product->description ?? '' ?></div>
                                <input type="hidden" id="description" name="description"
                                    value="<?= $product->description ?? '' ?>">
                            </div>

                            <div class="form-group">
                                <label class="form-label">Selling Price</label>
                                <div class="price-input-group">
                                    <span class="currency-symbol">N</span>
                                    <input type="number" class="form-control" id="product_price" name="product_price"
                                        placeholder="0" step="0.01"
                                        value="<?= htmlspecialchars($product->price ?? '') ?>" required />
                                </div>
                                <div class="price-helper-text">How much do you want to sell this product?</div>
                            </div>

                            <div class="form-group">
                                <label class="form-label">Discounted Price</label>
                                <div class="price-input-group">
                                    <span class="currency-symbol">N</span>
                                    <input type="number" class="form-control" id="discount_price" name="discount_price"
                                        placeholder="0" step="0.01"
                                        value="<?= htmlspecialchars($product->discount_price ?? '') ?>" />
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Product Images -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Product Images</h3>
                            <p class="section-subtitle">Select images for your product</p>
                        </div>
                        <div class="section-content">
                            <div class="image-upload-container">
                                <div class="image-upload" onclick="document.getElementById('imageInput').click()">
                                    <i class="fa fa-upload upload-icon"></i>
                                    <div class="upload-text">Click to upload</div>
                                </div>
                                <input type="file" id="imageInput" class="file-input" name="images[]" multiple
                                    accept="image/*" onchange="handleImageUpload(event)" />
                            </div>
                            <div class="upload-subtext">Supported formats are *.jpg and *.png and each image must not be
                                more than 2MB large</div>
                            <div id="imagePreview" class="image-preview-container">
                                <?php if (!empty($product->images)): ?>
                                    <?php foreach ($product->images as $image): ?>
                                        <?php
                                        $imageUrl = is_object($image) ? $image->url : $image['url'];
                                        $imageFilename = is_object($image) ? $image->filename : $image['filename'];
                                        ?>
                                        <div class="image-preview-item" data-existing-image="true"
                                            data-image-url="<?= htmlspecialchars($imageFilename) ?>">
                                            <img src="<?= $baseUrl ?>/<?= htmlspecialchars($imageUrl) ?>" alt="Product Image" />
                                            <button type="button" class="image-remove-btn"
                                                onclick="removeExistingImage(this, '<?= htmlspecialchars($imageFilename) ?>')">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Specifications -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Specifications</h3>
                            <p class="section-subtitle">Key features of your product that will help customers make their
                                purchasing decision.</p>
                        </div>
                        <div class="section-content">
                            <div id="specificationsList">
                                <?php if (!empty($product->specifications)): ?>
                                    <?php foreach ($product->specifications as $spec): ?>
                                        <div class="spec-item">
                                            <input type="text" name="specifications[name][]"
                                                placeholder="Feature name (e.g., Weight)" class="spec-name"
                                                value="<?= htmlspecialchars($spec['name'] ?? '') ?>" required>
                                            <input type="text" name="specifications[value][]"
                                                placeholder="Feature value (e.g., 2kg)" class="spec-value"
                                                value="<?= htmlspecialchars($spec['value'] ?? '') ?>" required>
                                            <button type="button" class="delete-btn" onclick="removeSpecification(this)">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            <button type="button" class="add-spec-btn" onclick="addSpecification()">
                                <i class="fa fa-plus"></i> Add Specification
                            </button>
                        </div>
                    </div>

                    <!-- Attributes (Variants) -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Attributes</h3>
                            <p class="section-subtitle">Versions of your product to provide options for your customers
                                to choose from.</p>
                        </div>
                        <div class="section-content">
                            <div class="variants-header">
                                <button type="button" class="load-variant-btn"
                                    onclick="alert('Load variant group functionality not implemented yet.')">
                                    Load saved variant group <i class="fa fa-chevron-down"></i>
                                </button>
                                <button type="button" class="create-new-btn" onclick="createNewVariant()">
                                    <i class="fa fa-plus-circle"></i> Create new
                                </button>
                            </div>
                            <div id="attributesList">
                                <?php if (!empty($product->attributes)): ?>
                                    <?php foreach ($product->attributes as $attrName => $options): ?>
                                        <div class="variant-form">
                                            <div class="variant-name-input">
                                                <label class="form-label">Attribute Name</label>
                                                <input type="text" class="form-control" name="attribute_name[]"
                                                    placeholder="Enter attribute name (e.g., Color)"
                                                    value="<?= htmlspecialchars($attrName) ?>" required>
                                            </div>
                                            <?php foreach ($options as $option): ?>
                                                <div class="variant-row">
                                                    <input type="text" class="form-control" name="attribute_value[]"
                                                        placeholder="Value (e.g., Red)"
                                                        value="<?= htmlspecialchars($option['value'] ?? '') ?>" required>
                                                    <input type="number" class="form-control" name="attribute_quantity[]"
                                                        placeholder="Quantity" min="0"
                                                        value="<?= htmlspecialchars($option['quantity'] ?? '') ?>" required>
                                                    <button type="button" class="delete-btn" onclick="removeVariant(this)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            <?php endforeach; ?>
                                            <button type="button" class="add-attribute-btn"
                                                onclick="addAttributeOption(this)">Add Option</button>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Stock -->
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Stock</h3>
                            <p class="section-subtitle">Total number of this product available for sale.</p>
                        </div>
                        <div class="section-content">
                            <div class="form-group">
                                <label class="form-label">Total stock</label>
                                <input type="number" class="form-control" id="stock_quantity" name="stock_quantity"
                                    placeholder="Enter total stock" min="0"
                                    value="<?= htmlspecialchars($product->stock_quantity ?? '') ?>" required />
                            </div>
                        </div>
                    </div>
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Stock Reminder</h3>
                            <p class="section-subtitle">Set a number to get an email alert when your stock gets low.</p>
                        </div>
                        <div class="section-content">
                            <div class="form-group">
                                <label class="form-label">Alert me when stock reaches </label>
                                <input type="number" class="form-control" id="stock_reminder" name="stock_reminder"
                                    placeholder="e.g. 5" min="0"
                                    value="<?= htmlspecialchars($product->stock_reminder ?? '') ?>" required />
                            </div>
                        </div>
                    </div>
                    <?php if (!empty($product->admin_reason)): ?>
                        <div class="admin-reason">
                            <strong>Admin Reason:</strong> <?= htmlspecialchars($product->admin_reason) ?>
                        </div>
                    <?php endif; ?>
                </div>


                <!-- Right Column - Settings -->
                <div class="col-md-4">
                    <div class="form-section">
                        <div class="section-header">
                            <h3 class="section-title">Settings</h3>
                            <p class="section-subtitle">Configure preferences for this product</p>
                        </div>
                        <div class="section-content">
                            <!-- <div class="settings-item">
                                <span class="settings-label">Limit product sale</span>
                                <div class="toggle-switch <?= ($product->sale_limit ?? false) ? 'active' : '' ?>"
                                    onclick="toggleLimitSale(this)"></div>
                            </div>
                            <div class="limit-input <?= ($product->sale_limit ?? false) ? 'show' : '' ?>"
                                id="limitInput">
                                <input type="number" class="form-control" name="sale_limit" placeholder="Enter limit"
                                    min="1" value="<?= htmlspecialchars($product->sale_limit ?? '') ?>" />
                            </div>
                            <div class="settings-item">
                                <span class="settings-label">Show number of sales on product page</span>
                                <div class="toggle-switch <?= ($product->show_sales ?? false) ? 'active' : '' ?>"
                                    onclick="toggleSwitch(this)"></div>
                            </div> -->

                            <div class="d-flex flex-column mt-4">

                                <button type="submit" class="btn-primary" name="action" value="pending">Update</button>
                                <button type="button" class="btn-text" onclick="previewProduct()">Preview</button>
                                <input type="hidden" id="actionHidden" name="action" value="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>


<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<script>
    // If you want to log product data, pass it from PHP to JS as JSON:
    var product = <?= json_encode($product) ?>;

    // Initialize Quill Editor
    var quill = new Quill("#editor", {
        theme: "snow",
        placeholder: "Provide a description...",
        modules: {
            toolbar: [
                [{
                    header: [1, 2, 3, false]
                }],
                ["bold", "italic", "underline"],
                ["link"],
                [{
                    list: "ordered"
                }, {
                    list: "bullet"
                }],
                ["clean"],
            ],
        },
    });

    // Update hidden description field on Quill change
    quill.on('text-change', function () {
        document.getElementById('description').value = quill.root.innerHTML;
    });

    // Navigation function
    function navigateTo(page) {
        window.location.href = page === 'dashboard' ? 'vendor_dashboard.php' : '#';
    }

    // Image upload handling
    let uploadedFiles = [];
    let removedExistingImages = [];

    function handleImageUpload(event) {
        const files = Array.from(event.target.files);
        uploadedFiles = uploadedFiles.concat(files);
        renderNewImagePreviews();
    }

    function renderNewImagePreviews() {
        const preview = document.getElementById("imagePreview");

        // Remove only new image previews, keep existing ones
        const newPreviews = preview.querySelectorAll('.image-preview-item:not([data-existing-image])');
        newPreviews.forEach(item => item.remove());

        uploadedFiles.forEach((file, index) => {
            if (file.type.startsWith("image/")) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    const previewItem = document.createElement("div");
                    previewItem.className = "image-preview-item";

                    const img = document.createElement("img");
                    img.src = e.target.result;

                    const removeBtn = document.createElement("button");
                    removeBtn.className = "image-remove-btn";
                    removeBtn.innerHTML = '<i class="fa fa-times"></i>';
                    removeBtn.type = "button";
                    removeBtn.onclick = function () {
                        removeNewImage(index);
                    };

                    previewItem.appendChild(img);
                    previewItem.appendChild(removeBtn);
                    preview.appendChild(previewItem);
                };
                reader.readAsDataURL(file);
            }
        });

        // Update the file input with current files
        updateFileInput();
    }

    function removeNewImage(index) {
        uploadedFiles.splice(index, 1);
        renderNewImagePreviews();
    }

    function removeExistingImage(button, imageUrl) {
        // Add to removed images array
        removedExistingImages.push(imageUrl);
        // Remove the preview item
        button.closest('.image-preview-item').remove();
    }

    function updateFileInput() {
        const dataTransfer = new DataTransfer();
        uploadedFiles.forEach(file => {
            dataTransfer.items.add(file);
        });
        document.getElementById('imageInput').files = dataTransfer.files;
    }

    // Specification management
    function addSpecification() {
        const specsList = document.getElementById("specificationsList");
        const specItem = document.createElement("div");
        specItem.className = "spec-item";
        specItem.innerHTML = `
            <input type="text" name="specifications[name][]" placeholder="Feature name (e.g., Weight)" class="spec-name" required>
            <input type="text" name="specifications[value][]" placeholder="Feature value (e.g., 2kg)" class="spec-value" required>
            <button type="button" class="delete-btn" onclick="removeSpecification(this)">
                <i class="fa fa-trash"></i>
            </button>
        `;
        specsList.appendChild(specItem);
    }

    function removeSpecification(button) {
        button.parentElement.remove();
    }

    // Attribute (Variant) management
    function createNewVariant() {
        const attributesList = document.getElementById("attributesList");
        const variantItem = document.createElement("div");
        variantItem.className = "variant-form";
        variantItem.innerHTML = `
            <div class="variant-name-input">
                <label class="form-label">Attribute Name</label>
                <input type="text" class="form-control" name="attribute_name[]" placeholder="Enter attribute name (e.g., Color)" required>
            </div>
            <div class="variant-row">
                <input type="text" class="form-control" name="attribute_value[]" placeholder="Value (e.g., Red)" required>
                <input type="number" class="form-control" name="attribute_quantity[]" placeholder="Quantity" min="0" required>
                <button type="button" class="delete-btn" onclick="removeVariant(this)">
                    <i class="fa fa-trash"></i>
                </button>
            </div>
            <button type="button" class="add-attribute-btn" onclick="addAttributeOption(this)">Add Option</button>
        `;
        attributesList.appendChild(variantItem);
    }

    function addAttributeOption(button) {
        const variantRow = document.createElement("div");
        variantRow.className = "variant-row";
        variantRow.innerHTML = `
            <input type="text" class="form-control" name="attribute_value[]" placeholder="Value (e.g., Red)" required>
            <input type="number" class="form-control" name="attribute_quantity[]" placeholder="Quantity" min="0" required>
            <button type="button" class="delete-btn" onclick="removeVariant(this)">
                <i class="fa fa-trash"></i>
            </button>
        `;
        button.parentElement.insertBefore(variantRow, button);
    }

    function removeVariant(button) {
        const variantRow = button.closest(".variant-row");
        const variantForm = button.closest(".variant-form");

        // Count how many variant rows exist in this form
        const rowsInForm = variantForm ? variantForm.querySelectorAll(".variant-row").length : 0;

        // If this is the last row in the attribute, remove the entire attribute form
        if (rowsInForm <= 1) {
            if (variantForm) {
                variantForm.remove();
            }
        } else {
            // Otherwise, just remove this specific option row
            if (variantRow) {
                variantRow.remove();
            }
        }
    }

    // Toggle switch functionality
    function toggleSwitch(element) {
        element.classList.toggle("active");
    }

    function toggleLimitSale(element) {
        element.classList.toggle("active");
        const limitInput = document.getElementById("limitInput");
        limitInput.classList.toggle("show");
    }

    // Preview product
    function previewProduct() {
        const name = document.getElementById("product_name").value;
        const description = quill.root.innerHTML;
        const price = document.getElementById("product_price").value;

        const previewWindow = window.open("", "Product Preview");
        previewWindow.document.write(`
            <html>
                <head>
                    <title>Product Preview</title>
                    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css">
                    <style>
                        body { padding: 20px; }
                        .preview-container { max-width: 800px; margin: auto; }
                        .preview-image { max-width: 200px; margin: 10px 0; }
                    </style>
                </head>
                <body>
                    <div class="preview-container">
                        <h2>${name || "Product Name"}</h2>
                        <div>${description || "Product Description"}</div>
                        <div>Price: N${price || "0.00"}</div>
                        <div id="previewImages"></div>
                    </div>
                </body>
            </html>
        `);

        const images = document.getElementById("imageInput").files;
        const previewImages = previewWindow.document.getElementById("previewImages");
        for (let i = 0; i < images.length; i++) {
            const reader = new FileReader();
            reader.onload = function (e) {
                const img = previewWindow.document.createElement("img");
                img.src = e.target.result;
                img.className = "preview-image";
                previewImages.appendChild(img);
            };
            reader.readAsDataURL(images[i]);
        }
    }

    $(document).ready(function () {
        // Set action value on button click

        $('#product_edit_form button[type=submit]').on('click', function () {
            var val = $(this).val();
            $('#actionHidden').val(val);
        });

        // Form validation and AJAX submission
        $('#product_edit_form').validator().on('submit', function (e) {
            e.preventDefault();

            // Validate required fields
            var actionClicked = $('#actionHidden').val();
            var productName = $('#product_name').val().trim();
            var productPrice = $('#product_price').val().trim();
            var stockQuantity = $('#stock_quantity').val().trim();

            if (actionClicked === 'pending' || actionClicked === 'archived') {
                if (!productName) {
                    alert('Please enter a product name before submitting.');
                    return;
                }
                if (!productPrice || parseFloat(productPrice) <= 0) {
                    alert('Please enter a valid product price before submitting.');
                    return;
                }
                if (stockQuantity === '' || parseInt(stockQuantity) < 0) {
                    alert('Please enter a valid stock quantity before submitting.');
                    return;
                }
            }

            // Clean up empty specification rows
            $('#specificationsList .spec-item').each(function () {
                var nameInput = $(this).find('input[name="specifications[name][]"]').val().trim();
                var valueInput = $(this).find('input[name="specifications[value][]"]').val().trim();
                if (!nameInput || !valueInput) {
                    $(this).remove(); // Remove empty specification rows
                }
            });

            // // Validate that at least one specification exists (if required)
            // if ($('#specificationsList .spec-item').length === 0 && actionClicked === 'pending') {
            //     alert('Please add at least one valid specification.');
            //     return;
            // }

            // Restructure specifications to match PHP expectations
            var specifications = [];
            $('#specificationsList .spec-item').each(function () {
                var nameInput = $(this).find('input[name="specifications[name][]"]').val().trim();
                var valueInput = $(this).find('input[name="specifications[value][]"]').val().trim();
                if (nameInput && valueInput) {
                    specifications.push({
                        name: nameInput,
                        value: valueInput
                    });
                }
            });

            var formData = new FormData($('#product_edit_form')[0]);
            formData.append('specifications', JSON.stringify(specifications));

            // Add removed existing images
            if (removedExistingImages.length > 0) {
                formData.append('removed_images', JSON.stringify(removedExistingImages));
            }

            // const images = document.getElementById('imageInput').files;
            // for (let i = 0; i < images.length; i++) {
            //     formData.append('images[]', images[i]);
            // }

            $('#myLoading').modal({
                keyboard: false,
                show: true,
                backdrop: "static"
            });

            //console.log("FormData", $('#imageInput')[0]);
            //console.log("AJAX Success:", formData);

            $.ajax({
                type: "POST",
                url: "ajax/ad_vendor_update.php",
                data: formData,
                processData: false,
                contentType: false,
                dataType: "json",
                success: function (data) {
                    //                    console.log("AJAX Success:", data);
                    $('#myLoading').modal("hide");
                    if (data.success) {
                        $('#succPan').html(data.message).fadeIn(1000);
                        setTimeout(function () {
                            $('#succPan').fadeOut("slow");
                        }, 5000);
                    } else {
                        $('#errPan').html(data.message + (data.details ? '<br>Details: ' + data.details.join('<br>') : '')).fadeIn(1000);
                        setTimeout(function () {
                            $('#errPan').fadeOut("slow");
                        }, 5000);
                    }
                },
                error: function (xhr, status, error) {
                    console.error("AJAX Error:", xhr, status, error);
                    $('#myLoading').modal("hide");
                    $('#errPan').text("Sorry, cannot contact server at this time. Please try again later!").fadeIn(1000);
                    setTimeout(function () {
                        $('#errPan').fadeOut("slow");
                    }, 5000);
                }
            });
        });

        // Initialize with one specification if none exist
        if (!document.querySelectorAll('#specificationsList .spec-item').length) {
            addSpecification();
        }
    });
</script>
<?php include_once 'includes/footer_end.php'; ?>