<?php
$page = "Marketplace Vendor Products";
$page_url = "vendor_products";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'marketdash';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$vendor_id = $_SESSION[$sid . 'userid'];

$vendor_check = $dashboard->vendorProductDashboard($vendor_id);
$lastSales = $dashboard->getsalesByGlobalId($_SESSION[$sid . 'userid']);

$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
?>

<!-- Include DataTables and Bootstrap Datepicker CSS/JS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>

<style>
    /* Retain provided CSS with DataTables-specific adjustments */
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .top-bar-buttons {
        display: flex;
        gap: 10px;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 5px 0 10px;
        font-size: 14px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
    }

    .breadcrumb a:hover {
        color: #0d3e9b;
    }

    .sales-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .search-area {
        display: flex;
        justify-content: space-between;
        margin: 20px 0;
        flex-wrap: wrap;
        gap: 10px;
    }

    .search-input {
        flex: 1;
        max-width: 300px;
        position: relative;
    }

    .search-input input {
        width: 100%;
        padding: 8px 40px 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .search-input i {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
    }

    .button-filters {
        display: flex;
        gap: 10px;
    }

    .filter-btn,
    .export-btn {
        border: 1px solid #ddd;
        padding: 8px 16px;
        border-radius: 4px;
        background: #f8f9fa;
        color: #333;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
    }

    .filter-btn:hover,
    .export-btn:hover {
        background: #e9ecef;
    }

    .products-table {
        margin: 0;
        width: 100%;
        border-collapse: collapse;
    }

    .products-table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .products-table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
    }

    .products-table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        border-bottom: 1px solid #f8f9fa;
    }

    .products-table tbody tr:hover {
        background: #f8f9fa;
    }

    .product-link {
        color: #333;
        font-weight: 500;
        text-decoration: none;
    }

    .product-link:hover {
        color: #0d3e9b;
    }

    .status-label {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        color: white;
        font-weight: 500;
    }

    .status-active {
        background: #0d3e9b;
    }

    .status-pending {
        background: #FFDE00;
        color: #333;
    }

    .status-rejected {
        background: red;
    }

    .status-archived {
        background: #6c757d;
    }

    .action-container {
        position: relative;
    }

    .itemdropdown {
        display: none;
        position: absolute;
        background-color: white;
        box-shadow: 0px 2px 8px rgba(0, 0, 0, 0.2);
        z-index: 10;
        right: 0;
        top: 45px;
        min-width: 160px;
        border-radius: 6px;
        overflow: hidden;
        max-height: 220px;
        overflow-y: auto;
    }

    .actions-header {
        padding: 10px 15px;
        border-bottom: 1px solid #eee;
        font-weight: 600;
        color: #333;
    }

    .itemdropdown a {
        padding: 10px 15px;
        display: block;
        text-decoration: none;
        color: #333;
    }

    .itemdropdown a:hover {
        background-color: #f1f1f1;
    }

    .itemdropdown a.delete-btn {
        color: red;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 5px 10px;
        border: 1px solid #ddd;
        background: #f8f9fa;
        border-radius: 4px;
        color: #6c757d;
        margin: 0 2px;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background: #e9ecef;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: #1976d2;
        color: white;
        border-color: #1976d2;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .dataTables_info {
        color: #6c757d;
        font-size: 14px;
        padding: 20px 25px;
    }

    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 10000;
        align-items: center;
        justify-content: center;
    }

    .modal-content {
        background: white;
        padding: 30px;
        border-radius: 12px;
        min-width: 400px;
        max-width: 600px;
        position: relative;
    }

    .close-btn {
        position: absolute;
        top: 10px;
        right: 15px;
        font-size: 20px;
        cursor: pointer;
        color: #6c757d;
    }

    .modal-header {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin-bottom: 20px;
    }

    .modal-body .form-group {
        margin-bottom: 15px;
    }

    .modal-body label {
        display: block;
        margin-bottom: 5px;
        font-weight: 500;
    }

    .modal-body input,
    .modal-body select {
        width: 100%;
        padding: 8px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }

    .modal-footer {
        text-align: right;
        margin-top: 20px;
    }

    .btn-primary {
        background: #1976d2;
        color: white;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .btn-primary:hover {
        background: #0d3e9b;
    }

    .btn-cancel {
        background: #6c757d;
        color: white;
        padding: 8px 16px;
        border: none;
        border-radius: 4px;
        margin-right: 10px;
    }

    .btn-save {
        background: #0d3e9b;
        color: white;
        padding: 8px 16px;
        border: none;
        border-radius: 4px;
    }

    .alert {
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 20px;
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-danger {
        background: #fee2e2;
        border: 1px solid #fecaca;
        color: #dc2626;
    }

    .alert-success {
        background: #d1fae5;
        border: 1px solid #6ee7b7;
        color: #065f46;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .search-area {
            flex-direction: column;
            align-items: stretch;
        }

        .search-input {
            max-width: none;
        }

        .stat-card {
            margin-bottom: 15px;
        }

        .products-table th,
        .products-table td {
            padding: 10px 15px;
        }

        .modal-content {
            min-width: 90%;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Products</h1>
        <div class="top-bar-buttons">
            <button class="btn btn-primary" onclick="window.location.href='vendor_add_product.php'">
                <i class="fa fa-plus" style="margin-right: 8px"></i>Add a Product
            </button>
            <button class="btn btn-primary export-btn" onclick="exportToCSV()">
                <i class="fa fa-download" style="margin-right: 8px"></i>Export as CSV
            </button>
        </div>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <?php if ($vendor_check === null): ?>
            <div
                style="padding: 20px; border: 1px solid #f44336; background-color: #ffebee; color: #b71c1c; border-radius: 8px; text-align: center;">
                <h2>Vendor Account Not Available</h2>
                <p>You need to create a vendor account to access this dashboard.</p>
                <a href="/eservice/add_vendor"
                    style="display: inline-block; padding: 10px 20px; background-color: #1976d2; color: white; text-decoration: none; border-radius: 4px; font-weight: bold;">Create
                    Vendor Account</a>
            </div>
        <?php else: ?>
            <!-- Breadcrumb -->
            <nav class="breadcrumb">
                <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
                <span style="color: #6c757d; margin: 0 8px">></span>
                <span style="color: #333">Products</span>
            </nav>

            <!-- Stats Row -->
            <div class="row stats-row">
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Revenue</div>
                            <div class="stat-icon">
                                <i class="fa fa-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">₦<?= number_format($vendor_check['total_revenue'], 2) ?></div>
                        <div class="stat-label">Sum of all sales transactions</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Sales</div>
                            <div class="stat-icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= $vendor_check['total_orders'] ?></div>
                        <div class="stat-label">Orders made in the last 30 days</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Active Products</div>
                            <div class="stat-icon">
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= htmlspecialchars($vendor_check['active_products'] ?? 'N/A') ?></div>
                        <div class="stat-label">Total active products</div>
                    </div>
                </div>
            </div>

            <!-- Search and Filter Area -->
            <div class="search-area">
                <div class="search-input">
                    <input type="text" class="form-control" placeholder="Search products" id="productSearch" />
                    <i class="fa fa-search"></i>
                </div>
                <div class="button-filters">
                    <button class="filter-btn" data-toggle="modal" data-target="#filterModal">
                        <i class="fa fa-filter"></i> Filter
                    </button>
                </div>
            </div>

            <!-- Products Section -->
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Products</h3>
                        <p class="sales-subtitle">Manage your products and view their sales performance.</p>
                    </div>
                </div>

                <!-- Products Table -->
                <div class="table-responsive">
                    <table class="products-table" id="productsTable">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selectAll" onchange="toggleSelectAll()" /> Name</th>
                                <th>Status</th>
                                <th>Revenue</th>
                                <th>Total Sales</th>
                                <th>Created At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Add Stock Modal -->
    <div id="addStockModal" class="modal"></div>

    <!-- Submit for Review Modal -->
    <div id="submitForReviewModal" class="modal"></div>

    <!-- Filter Modal -->
    <div class="modal fade" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="filterModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="filterModalLabel">Filter Products</h5>

                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="filterStatus">Status</label>
                        <select id="filterStatus" class="form-control">
                            <option value="">All Status</option>
                            <option value="active">Active</option>
                            <option value="pending">Pending</option>
                            <option value="rejected">Rejected</option>
                            <option value="archived">Archived</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="startDate">Start Date</label>
                        <input type="text" class="form-control datepicker" id="startDate" placeholder="YYYY-MM-DD">
                    </div>
                    <div class="form-group">
                        <label for="endDate">End Date</label>
                        <input type="text" class="form-control datepicker" id="endDate" placeholder="YYYY-MM-DD">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-cancel" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-save" onclick="applyFilters()">Apply Filters</button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    $(document).ready(function () {
        let currentStatus = null;
        let currentStartDate = null;
        let currentEndDate = null;

        // Initialize Datepickers
        $('#startDate, #endDate').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true
        });

        // Initialize DataTables
        const table = $('#productsTable').DataTable({
            serverSide: true,
            processing: true,
            pageLength: 10,
            lengthChange: false,
            searching: false,
            ordering: true,
            info: true,
            ajax: {
                url: 'ajax/ajax_vendor_products.php',
                type: 'GET',
                data: function (d) {
                    d.page = Math.floor(d.start / d.length) + 1;
                    d.search = $('#productSearch').val();
                    d.status = currentStatus;
                    d.startDate = currentStartDate;
                    d.endDate = currentEndDate;
                },
                error: function (xhr, error, thrown) {
                    console.log('DataTables AJAX error:', xhr, error, thrown);
                    showNotification('Failed to load products. Check the console for details.', 'error');
                }
            },
            columns: [{
                data: 'name',
                orderable: true
            },
            {
                data: 'status',
                orderable: true
            },
            {
                data: 'revenue',
                orderable: true
            },
            {
                data: 'total_sales',
                orderable: true
            },
            {
                data: 'created_at',
                orderable: true
            },
            {
                data: 'actions',
                orderable: false
            }
            ],
            drawCallback: function () {
                // Rebind action dropdown events
                $('.action-btn').off('click').on('click', function (e) {
                    e.preventDefault();
                    const itemdropdown = $(this).closest('.action-container').find('.itemdropdown');
                    $('.itemdropdown').not(itemdropdown).hide();
                    itemdropdown.toggle();
                });

                // Add Stock button
                $('.add-stock-btn').off('click').on('click', function (e) {
                    e.preventDefault();
                    const productId = $(this).data('product-id');
                    const productName = $(this).data('product-name');
                    showAddStockModal(productId, productName);
                    $(this).closest('.itemdropdown').hide();
                });

                // Submit for review

                $('.submit-for-review').off('click').on('click', function (e) {
                    e.preventDefault();
                    const productId = $(this).data('product-id');
                    const productName = $(this).data('product-name');
                    showSubmitForReviewModal(productId, productName);
                    $(this).closest('.itemdropdown').hide();
                });

                // Copy Link button
                $('.copy-link-btn').off('click').on('click', function (e) {
                    e.preventDefault();
                    const productId = $(this).data('product-id');
                    const productLink = `${window.location.origin}/vendor_product_detail.php?id=${encodeURIComponent(btoa(productId))}`;
                    navigator.clipboard.writeText(productLink).then(() => {
                        showNotification('Product link copied to clipboard!', 'success');
                        $(this).closest('.itemdropdown').hide();
                    });
                });

                // Archive button
                $('.archive-btn').off('click').on('click', function (e) {
                    e.preventDefault();
                    const productId = $(this).data('product-id');
                    showNotification(`Archiving product with ID: ${productId}`, 'success');
                    $(this).closest('.itemdropdown').hide();
                    // Add AJAX call to archive product here
                });

                // Delete button
                $('.delete-btn').off('click').on('click', function (e) {
                    e.preventDefault();
                    const productId = $(this).data('product-id');
                    if (confirm(`Are you sure you want to delete product with ID: ${productId}?`)) {
                        showNotification(`Deleting product with ID: ${productId}`, 'success');
                        $(this).closest('.itemdropdown').hide();
                        // Add AJAX call to delete product here
                    }
                });
            }
        });

        // Custom search
        $('#productSearch').on('input', function () {
            table.ajax.reload();
        });

        // Apply filters
        window.applyFilters = function () {
            currentStatus = $('#filterStatus').val();
            currentStartDate = $('#startDate').val();
            currentEndDate = $('#endDate').val();
            $('#filterModal').modal('hide');
            table.ajax.reload();
        };

        // Toggle select all checkboxes
        window.toggleSelectAll = function () {
            const selectAllCheckbox = $('#selectAll')[0];
            const productCheckboxes = $('.product-checkbox');
            productCheckboxes.prop('checked', selectAllCheckbox.checked);
        };

        // filepath: c:\xampp\htdocs\eservice\vendor_products.php
        window.showAddStockModal = function (productId, productName) {
            const modal = `
        <div class="modal-content">
            <span class="close-btn" onclick="closeModal()">&times;</span>
            <div class="modal-header">Add Stock for ${productName}</div>
            <div class="modal-body">
                <form id="addStockForm">
                    <div class="form-group">
                        <label for="stockQuantity">Stock Quantity</label>
                        <input type="number" id="stockQuantity" name="stock_quantity" min="1" required>
                        <input type="hidden" id="productId" name="product_id" value="${productId}">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-cancel" onclick="closeModal()">Cancel</button>
                        <button type="submit" class="btn btn-save">Save</button>
                    </div>
                </form>
            </div>
        </div>`;
            $('#addStockModal').html(modal).css('display', 'flex');

            // Handle form submission
            $('#addStockForm').off('submit').on('submit', function (e) {
                e.preventDefault();
                const productId = $('#productId').val();
                const stockQuantity = $('#stockQuantity').val();

                // Show loading modal if you have one
                // $('#myLoading').modal({ keyboard: false, show: true, backdrop: "static" });

                $.ajax({
                    type: "POST",
                    url: "ajax/vendor_product_stock.php",
                    data: {
                        productId: productId,
                        stockQuantity: stockQuantity
                    },
                    dataType: "json",
                    success: function (data) {
                        // $('#myLoading').modal("hide");
                        if (data.success) {
                            showNotification(data.message, 'success');
                            $('#productsTable').DataTable().ajax.reload();
                        } else {
                            showNotification(data.message, 'error');
                        }
                        closeModal();
                    },
                    error: function (xhr, status, error) {
                        // $('#myLoading').modal("hide");
                        showNotification("Sorry, cannot contact server at this time. Please try again later!", 'error');
                        closeModal();
                    }
                });
            });
        };

        window.closeModal = function () {
            $('#addStockModal').css('display', 'none').empty();
        };
        // Close modal

        // Submit for Review Modal
        window.showSubmitForReviewModal = function (productId, productName) {
            const modal = `
        <div class="modal-content">
            <span class="close-btn" onclick="closeModal()">&times;</span>
            <div class="modal-header">Submit ${productName} for Review</div>
            <div class="modal-body">
                <form id="submitForReview">
                    <div class="form-group">
                        <p>The above product will be submitted for review. This action cannot be undone
                         <input type="hidden" id="productId" name="product_id" value="${productId}">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-cancel" onclick="closeModal()">Cancel</button>
                        <button type="submit" class="btn btn-save">Submit</button>
                    </div>
                </form>
            </div>
        </div>`;
            $('#submitForReviewModal').html(modal).css('display', 'flex');

            // Handle form submission
            $('#submitForReview').off('submit').on('submit', function (e) {
                e.preventDefault();
                const productId = $('#productId').val();


                // Show loading modal if you have one
                // $('#myLoading').modal({ keyboard: false, show: true, backdrop: "static" });

                $.ajax({
                    type: "POST",
                    url: "ajax/vendor_submit_archiveproduct.php",
                    data: {
                        productId: productId,
                    },
                    dataType: "json",
                    success: function (data) {
                        // $('#myLoading').modal("hide");
                        if (data.success) {
                            showNotification(data.message, 'success');
                            $('#productsTable').DataTable().ajax.reload();
                        } else {
                            showNotification(data.message, 'error');
                        }
                        closeModal();
                    },
                    error: function (xhr, status, error) {
                        // $('#myLoading').modal("hide");
                        showNotification("Sorry, cannot contact server at this time. Please try again later!", 'error');
                        closeModal();
                    }
                });
            });
        };

        window.closeModal = function () {
            $('#submitForReviewModal').css('display', 'none').empty();
        };


        // Export to CSV
        window.exportToCSV = function () {
            $.ajax({
                url: 'ajax/ajax_vendor_products.php',
                type: 'GET',
                data: {
                    action: 'export',
                    search: $('#productSearch').val(),
                    status: currentStatus,
                    startDate: currentStartDate,
                    endDate: currentEndDate
                },
                success: function (response) {
                    const data = response.data;
                    let csvContent = 'Product ID,Name,Status,Revenue,Total Sales,Created At\n';
                    data.forEach(row => {
                        const cleanRevenue = row.revenue.replace(/[^\d.,]/g, '');
                        csvContent += `"${row.product_id}","${row.product_name}","${row.status}","${cleanRevenue}","${row.total_sales}","${row.created_at}"\n`;
                    });
                    const blob = new Blob([csvContent], {
                        type: 'text/csv;charset=utf-8;'
                    });
                    const link = document.createElement('a');
                    link.href = URL.createObjectURL(blob);
                    link.download = 'products_export.csv';
                    link.click();
                },
                error: function () {
                    showNotification('Failed to export products. Please try again.', 'error');
                }
            });
        };

        // Notification system
        window.showNotification = function (message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'}`;
            notification.innerHTML = `
                <button type="button" class="close" onclick="this.parentElement.remove()">
                    <span>&times;</span>
                </button>
                <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
            `;
            document.body.appendChild(notification);
            setTimeout(() => {
                if (notification.parentElement) {
                    notification.remove();
                }
            }, 5000);
        };

        // Navigation function
        window.navigateTo = function (page) {
            window.location.href = page === 'dashboard' ? 'vendor_dashboard.php' : '#';
        };

        // Close dropdowns when clicking outside
        $(document).on('click', function (e) {
            if (!$(e.target).closest('.action-container').length) {
                $('.itemdropdown').hide();
            }
        });

        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>