<?php
$page = "Marketplace Vendor Sales";
$page_url = "vendor_sales";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'marketdash';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
$vendor_check = $dashboard->getDashboardByGlobalId($_SESSION[$sid . 'userid']);

if ($vendor_id !== null) {
    $vendorOrders = $dashboard->getVendorOrders($vendor_id, $status = "fulfilled");
}
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
?>

<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 5px 0 10px;
        font-size: 14px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
    }

    .breadcrumb a:hover {
        color: #0d3e9b;
    }

    .sales-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .table-responsive {
        overflow-x: auto;
    }

    .table {
        margin: 0;
    }

    .table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
    }

    .table tbody tr {
        border-bottom: 1px solid #f8f9fa;
    }

    .table tbody td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
    }

    .table tbody tr:hover {
        background: #f8f9fa;
    }

    .customer-info {
        display: flex;
        align-items: center;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 6px;
        margin-right: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
        background: #e9ecef;
    }

    .customer-details h6 {
        margin: 0;
        color: #333;
        font-size: 14px;
        font-weight: 500;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .label {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        color: white;
        font-weight: 500;
    }

    .label-fulfilled {
        background: #0d3e9b;
    }

    .label-pending {
        background: #ffc107;
    }

    .label-cancelled {
        background: #f44336;
    }

    .label-refunded {
        background: #6c757d;
    }

    .avatar-pink {
        background: #e91e63;
    }

    .avatar-blue {
        background: #2196f3;
    }

    .avatar-orange {
        background: #ff9800;
    }

    .avatar-green {
        background: #4caf50;
    }

    .avatar-purple {
        background: #9c27b0;
    }

    .avatar-teal {
        background: #009688;
    }

    .avatar-red {
        background: #f44336;
    }

    .pagination-wrapper {
        padding: 20px 25px;
        border-top: 1px solid #f8f9fa;
        display: flex;
        justify-content: flex-end;
        gap: 8px;
        align-items: center;
    }

    .pagination-info {
        color: #6c757d;
        font-size: 14px;
    }

    .btn-sm {
        border: 1px solid #ddd;
        padding: 5px 10px;
        font-size: 12px;
    }

    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 10000;
        align-items: center;
        justify-content: center;
    }

    .modal-content {
        background: white;
        padding: 30px;
        border-radius: 12px;
        min-width: 400px;
        max-width: 600px;
        position: relative;
    }

    .close-btn {
        position: absolute;
        top: 10px;
        right: 15px;
        font-size: 20px;
        cursor: pointer;
        color: #6c757d;
    }

    .modal-header {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin-bottom: 20px;
    }

    .modal-body .section-title {
        font-size: 16px;
        font-weight: 500;
        color: #333;
        margin: 20px 0 10px;
    }

    .modal-body .info-table {
        width: 100%;
        border-collapse: collapse;
    }

    .modal-body .info-table tr {
        border-bottom: 1px solid #f8f9fa;
    }

    .modal-body .info-table td {
        padding: 8px 0;
        color: #333;
        font-size: 14px;
    }

    .modal-body .info-table td:first-child {
        width: 40%;
        color: #6c757d;
    }

    .input-group {
        width: 300px;
        display: inline-block;
        margin-right: 15px;
    }

    .form-control {
        border-radius: 4px 0 0 4px;
        border: 1px solid #ddd;
        padding: 8px 12px;
    }

    .input-group-btn .btn {
        border-radius: 0 4px 4px 0;
        border: 1px solid #ddd;
        border-left: none;
        padding: 8px 12px;
    }

    .btn-default {
        border: 1px solid #ddd;
        padding: 8px 16px;
        border-radius: 4px;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .input-group {
            width: 100%;
            margin-bottom: 10px;
        }

        .btn-default {
            width: 100%;
            text-align: center;
        }

        .stat-card {
            margin-bottom: 15px;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Sales</h1>
        <button class="btn btn-primary" onclick="exportToCSV()">
            <i class="fa fa-download" style="margin-right: 8px"></i>Export as CSV
        </button>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span style="color: #6c757d; margin: 0 8px">></span>
            <span style="color: #333">Sales</span>
        </nav>

        <?php if ($vendor_check === null): ?>
            <div
                style="padding: 20px; border: 1px solid #f44336; background-color: #ffebee; color: #b71c1c; border-radius: 8px; text-align: center;">
                <h2>Vendor Account Not Available</h2>
                <p>You need to create a vendor account to access this dashboard.</p>
                <a href="/eservice/add_vendor"
                    style="display: inline-block; padding: 10px 20px; background-color: #1976d2; color: white; text-decoration: none; border-radius: 4px; font-weight: bold;">Create
                    Vendor Account</a>
            </div>
        <?php else: ?>
            <!-- Stats Row -->
            <div class="row stats-row">
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Revenue</div>
                            <div class="stat-icon">
                                <i class="fa-regular fa-badge-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">N<?= number_format($vendor_check['total_revenue'], 2) ?></div>
                        <div class="stat-label">Sum of all sales transactions</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Total Sales</div>
                            <div class="stat-icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= $vendor_check['total_orders'] ?></div>
                        <div class="stat-label">Orders made in the last 30 days</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Calculated Profit</div>
                            <div class="stat-icon">
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                        <div class="stat-value"><?= htmlspecialchars($vendor_check['calculated_profit'] ?? 'N/A') ?></div>
                        <div class="stat-label">Estimated profit from sales</div>
                    </div>
                </div>
            </div>

            <!-- Sales Section -->
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Sales</h3>
                        <p class="sales-subtitle">Purchases made from your store online</p>
                    </div>

                </div>

                <!-- Sales Table -->
                <div class="table-responsive">
                    <table class="table table-hover" style="margin: 0">
                        <thead style="background: #f8f9fa; border-bottom: 1px solid #e9ecef">
                            <tr>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    <input type="checkbox" style="margin-right: 10px" id="selectAll">Customer
                                </th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    Product</th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    Status</th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    Price</th>
                                <th
                                    style="padding: 15px 25px; border: none; font-weight: 500; color: #6c757d; font-size: 14px;">
                                    Purchase Date</th>
                            </tr>
                        </thead>
                        <tbody id="salesTableBody">
                            <!-- Populated by JavaScript -->
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="pagination-wrapper">
                    <div class="pagination-info">Page 1 of 1</div>
                    <div>
                        <button class="btn btn-default btn-sm" onclick="goToFirstPage()" disabled>
                            <i class="fa fa-angle-double-left"></i>
                        </button>
                        <button class="btn btn-default btn-sm" onclick="previousPage()" disabled>
                            <i class="fa fa-angle-left"></i>
                        </button>
                        <button class="btn btn-default btn-sm" onclick="nextPage()">
                            <i class="fa fa-angle-right"></i>
                        </button>
                        <button class="btn btn-default btn-sm" onclick="goToLastPage()">
                            <i class="fa fa-angle-double-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Sale Details Modal -->
    <div id="saleModal" class="modal"></div>
</div>


<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    // Dynamic sales data from PHP
    const salesData = [
        <?php
        $avatar_colors = ['avatar-pink', 'avatar-blue', 'avatar-orange', 'avatar-green', 'avatar-purple', 'avatar-teal', 'avatar-red'];
        $color_index = 0;
        foreach ($vendorOrders as $order) {
            $initials = strtoupper(substr($order['customer_name'], 0, 1) . (strpos($order['customer_name'], ' ') !== false ? substr($order['customer_name'], strpos($order['customer_name'], ' ') + 1, 1) : ''));
            echo "{
                order_id: '" . htmlspecialchars($order['order_id']) . "',
                customer: '" . htmlspecialchars($order['customer_name']) . "',
                email: '" . htmlspecialchars($order['customer_email']) . "',
                product: '" . htmlspecialchars($order['product_names'] ?? 'N/A') . "',
                status: '" . htmlspecialchars(strtolower($order['status'])) . "',
                price: " . floatval($order['total_amount']) . ",
                date: '" . date('Y-m-d H:i A', strtotime($order['created_at'])) . "',
                avatarClass: '" . $avatar_colors[$color_index] . "'
            },";
            $color_index = ($color_index + 1) % count($avatar_colors);
        }
        ?>
    ];

    let currentPage = 1;
    const rowsPerPage = 5;
    let filteredData = [...salesData];

    // Render table data
    function renderTable(data, page = 1) {
        const start = (page - 1) * rowsPerPage;
        const end = start + rowsPerPage;
        const paginatedData = data.slice(start, end);

        const tbody = $("#salesTableBody");
        tbody.empty();

        if (paginatedData.length === 0) {
            tbody.append(
                '<tr><td colspan="5" style="padding: 15px 25px; text-align: center; color: #6c757d;">No sales found for this vendor.</td></tr>'
            );
            return;
        }

        paginatedData.forEach((sale) => {
            const row = `
                <tr style="border-bottom: 1px solid #f8f9fa; cursor: pointer;">
                    <td style="padding: 15px 25px; border: none; vertical-align: middle;">
                        <div style="display: flex; align-items: center">
                            <input type="checkbox" style="margin-right: 15px" />
                            <div class="customer-info">
                                <div class="customer-avatar ${sale.avatarClass}">${sale.customer.split(' ').map(n => n[0]).join('').substring(0, 2)}</div>
                                <div class="customer-details">
                                    <h6>${sale.customer}</h6>
                                    <p>${sale.email}</p>
                                </div>
                            </div>
                        </td>
                        <td style="padding: 15px 25px; border: none; vertical-align: middle; color: #333;">${sale.product}</td>
                        <td style="padding: 15px 25px; border: none; vertical-align: middle;">
                            <span class="label label-${sale.status}">${sale.status.charAt(0).toUpperCase() + sale.status.slice(1)}</span>
                        </td>
                        <td style="padding: 15px 25px; border: none; vertical-align: middle; color: #333;">N${sale.price.toLocaleString()}</td>
                        <td style="padding: 15px 25px; border: none; vertical-align: middle; color: #6c757d;">${sale.date}</td>
                    </tr>`;
            tbody.append(row);
        });

        const totalPages = Math.ceil(data.length / rowsPerPage);
        $(".pagination-info").text(`Page ${page} of ${totalPages}`);
        updatePaginationButtons();
    }

    // Update pagination buttons state
    function updatePaginationButtons() {
        const totalPages = Math.ceil(filteredData.length / rowsPerPage);
        $(".btn-sm").prop("disabled", false);
        if (currentPage === 1) {
            $(".btn-sm:contains('angle-double-left')").prop("disabled", true);
            $(".btn-sm:contains('angle-left')").prop("disabled", true);
        }
        if (currentPage === totalPages || totalPages === 0) {
            $(".btn-sm:contains('angle-right')").prop("disabled", true);
            $(".btn-sm:contains('angle-double-right')").prop("disabled", true);
        }
    }

    // Search functionality
    $("#searchInput").on("keyup", function () {
        const searchTerm = $(this).val().toLowerCase();
        filteredData = salesData.filter(
            (sale) =>
                sale.customer.toLowerCase().includes(searchTerm) ||
                sale.product.toLowerCase().includes(searchTerm)
        );
        currentPage = 1;
        renderTable(filteredData, currentPage);
    });

    // Checkbox functionality
    $("#selectAll").change(function () {
        const isChecked = $(this).is(":checked");
        $("tbody input[type='checkbox']").prop("checked", isChecked);
    });

    // Filter modal
    function showFilterModal() {
        const modal = `
            <div class="modal" style="display: flex;">
                <div class="modal-content" onclick="event.stopPropagation()">
                    <span class="close-btn" onclick="closeModal()">&times;</span>
                    <div class="modal-header">Filter Sales</div>
                    <div class="modal-body">
                        <div style="margin-bottom: 15px;">
                            <label>Status:</label>
                            <select id="filterStatus" style="width: 100%; padding: 8px; margin-top: 5px; border: 1px solid #ddd; border-radius: 4px;">
                                <option value="">All Status</option>
                                <option value="fulfilled">Fulfilled</option>
                                <option value="pending">Pending</option>
                                <option value="cancelled">Cancelled</option>
                                <option value="refunded">Refunded</option>
                            </select>
                        </div>
                        <div style="margin-bottom: 15px;">
                            <label>Date Range:</label>
                            <div style="display: flex; align-items: center;">
                                <input type="date" id="startDate" style="width: 48%; padding: 8px; margin-top: 5px; border: 1px solid #ddd; border-radius: 4px;">
                                <span style="margin: 0 2%;">to</span>
                                <input type="date" id="endDate" style="width: 48%; padding: 8px; margin-top: 5px; border: 1px solid #ddd; border-radius: 4px;">
                            </div>
                        </div>
                        <div style="text-align: right; margin-top: 20px;">
                            <button class="btn btn-default" style="margin-right: 10px;" onclick="closeModal()">Cancel</button>
                            <button class="btn btn-primary" onclick="applyFilters()">Apply</button>
                        </div>
                    </div>
                </div>
            </div>`;
        $("body").append(modal);
    }

    // Apply filters
    function applyFilters() {
        const status = $("#filterStatus").val();
        const startDate = $("#startDate").val();
        const endDate = $("#endDate").val();

        filteredData = salesData.filter((sale) => {
            let statusMatch = !status || sale.status === status;
            let dateMatch = true;

            if (startDate || endDate) {
                const saleDate = new Date(sale.date);
                const start = startDate ? new Date(startDate) : new Date(0);
                const end = endDate ? new Date(endDate) : new Date();
                dateMatch = saleDate >= start && saleDate <= end;
            }

            return statusMatch && dateMatch;
        });

        currentPage = 1;
        renderTable(filteredData, currentPage);
        closeModal();
    }

    // Close modal
    function closeModal() {
        $(".modal").remove();
    }

    // Sale details (on row click)
    $("body").on("click", "tbody tr", function () {
        const customer = $(this).find(".customer-details h6").text();
        const email = $(this).find(".customer-details p").text();
        const product = $(this).find("td:eq(1)").text();
        const status = $(this).find(".label").text();
        const price = $(this).find("td:eq(3)").text();
        const date = $(this).find("td:eq(4)").text();
        const orderId = salesData[$(this).index() + (currentPage - 1) * rowsPerPage].order_id;

        const modal = `
            <div class="modal" style="display: flex;">
                <div class="modal-content">
                    <span class="close-btn" onclick="closeModal()">&times;</span>
                    <div class="modal-header">Sale Details</div>
                    <div class="modal-body">
                        <div class="section-title">Sale Information</div>
                        <table class="info-table">
                            <tr>
                                <td>Order ID:</td>
                                <td><a href="/eservice/order_detail.php?id=${encodeURIComponent(btoa(orderId))}" style="color: #0d3e9b; text-decoration: none;">#${orderId}</a></td>
                            </tr>
                            <tr>
                                <td>Customer:</td>
                                <td>${customer}</td>
                            </tr>
                            <tr>
                                <td>Email:</td>
                                <td>${email}</td>
                            </tr>
                            <tr>
                                <td>Product:</td>
                                <td>${product}</td>
                            </tr>
                            <tr>
                                <td>Status:</td>
                                <td><span class="label label-${status.toLowerCase()}">${status}</span></td>
                            </tr>
                            <tr>
                                <td>Price:</td>
                                <td>${price}</td>
                            </tr>
                            <tr>
                                <td>Purchase Date:</td>
                                <td>${date}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>`;
        $("#saleModal").html(modal);
    });

    // Export to CSV
    function exportToCSV() {
        let csvContent = "data:text/csv;charset=utf-8,";
        csvContent +=
            "Order ID,Customer,Email,Product,Status,Price,Date\n" +
            filteredData
                .map(
                    (row) =>
                        `${row.order_id},${row.customer},${row.email},${row.product},${row.status.charAt(0).toUpperCase() + row.status.slice(1)},N${row.price},${row.date}`
                )
                .join("\n");

        const encodedUri = encodeURI(csvContent);
        const link = document.createElement("a");
        link.setAttribute("href", encodedUri);
        link.setAttribute("download", "sales_export.csv");
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    }

    // Pagination controls
    function goToFirstPage() {
        if (currentPage !== 1) {
            currentPage = 1;
            renderTable(filteredData, currentPage);
        }
    }

    function previousPage() {
        if (currentPage > 1) {
            currentPage--;
            renderTable(filteredData, currentPage);
        }
    }

    function nextPage() {
        const totalPages = Math.ceil(filteredData.length / rowsPerPage);
        if (currentPage < totalPages) {
            currentPage++;
            renderTable(filteredData, currentPage);
        }
    }

    function goToLastPage() {
        const totalPages = Math.ceil(filteredData.length / rowsPerPage);
        if (currentPage !== totalPages) {
            currentPage = totalPages;
            renderTable(filteredData, currentPage);
        }
    }

    // Navigation function
    function navigateTo(page) {
        window.location.href = page === 'dashboard' ? 'vendor_dashboard.php' : '#';
    }

    // Initialize table
    $(document).ready(function () {
        renderTable(filteredData, currentPage);
    });
</script>